<?php
/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 */
defined('_JEXEC') or die;
defined('JPATH_PLATFORM') or die;


class PartSliderGrid{


    	/**
	 * @var String $display
	 */
	public $display;

	/**
	 * @var String $position
	 */
	public $position;
	
	/**
	 * @var String $steps
	 */
	public $items;
	
	/**
	 * @var String $steps
	 */
	public $rows;
		
	/**
	 * @var String $spacing
	 */
	public $spacing;
	
	/**
	 * @var String $margin
	 */
	public $margin;
	
	/**
	 * @var PartBorder $border
	 */
	public $border;
	
	/**
	 * @var PartBackground $background
	 */
	public $background;
		
	function __construct($preset = null){		
		$this->display = false;
		$this->position		= "bottom";

		$this->items 		= "8";
		$this->rows 		= "1";

		$this->spacing 		= "10";
		$this->margin		= "10";
		$this->background =	new PartBackgroundlink();
		$this->border = 	new PartBorder();
	}
	
	public function bind($data){

		if(isset($data->display))		$this->display = $data->display;
		if(isset($data->position))		$this->position = $data->position;
		
		if(isset($data->items))		$this->items = $data->items;
		if(isset($data->rows))		$this->rows = $data->rows;

		if(isset($data->spacing))		$this->spacing = $data->spacing;
		if(isset($data->margin))		$this->margin = $data->margin;				
		if (isset ( $data->border ))		$this->border->bind ( $data->border );
		if (isset ( $data->background ))		$this->background->bind ( $data->background );
	}
	
	public function codeWizard($partObject){}
}
