<?php
/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 */
defined('_JEXEC') or die;

defined('JPATH_PLATFORM') or die;

/**
 * Slider control class 
 * @package     CORE
 * @version 	1.0.0
 * @since       1.0.0
 */
 
class PartSliderSlider{
	
	/**
	 * @var String $fillmode
	 */
	public $fillmode;
	
	/**
	 * @var String $startindex
	 */
	public $startindex;
	
	/**
	 * @var String $loop
	 */
	public $loop;
	
	/**
	 * @var String $width
	 */
	public $width;
	
	/**
	 * @var String $height
	 */
	public $height;
	
	/**
	 * @var String $autoplay
	 */
	public $autoplay;
	
	/**
	 * @var String $autoplaysteps
	 */
	public $autoplaysteps;
	
	/**
	 * @var String $autoplayinterval
	 */
	public $autoplayinterval;
	
	/**
	 * @var String $pauseonhover
	 */
	public $pauseonhover;
	
	/**
	 * @var String $scale
	 */
	public $scale;
	
	/**
	 * @var String $arrowkeynavigation
	 */
	public $arrowkeynavigation;
	
	/**
	 * @var String $slideduration
	 */
	public $slideduration;
	
	/**
	 * @var String $slidespacing
	 */
	public $slidespacing;
	
	/**
	 * @var String $slidewidth
	 */
	public $slidewidth;
	
	/**
	 * @var String $orientation
	 */
	public $orientation;
	
	/**
	 * @var String $slidesnumber
	 */
	public $slidesnumber;
	
	
	/**
	 * @var String $dragorientation
	 */
	public $dragorientation;
	
	function __construct($preset = null){	
		
		$this->orientation 		= 'horizontal';
		$this->slidespacing 	= '0';
		$this->slidewidth 		= '600';
		$this->slidesnumber 	= '1';
		
		$this->fillmode 			= '0';
		$this->startindex 			= '0';
		$this->loop		 			= '1';
		$this->width		 		= '600';
		$this->height		 		= '300';
		$this->loop		 			= '1';
		$this->autoplay 			= '1';
		$this->autoplaysteps 		= '1';
		$this->autoplayinterval 	= '3000';
		$this->pauseonhover 		= '1';
		$this->cursoronhover 		= '0';
		$this->scale		 		= '0';
		$this->arrowkeynavigation	= '0';
		$this->slideduration 		= '500';
		$this->slidewidth 		= '600';
		$this->playorientation 		= '1';
		$this->dragorientation 		= '1';
	}
	
	public function bind($data){
		
		if(isset($data->orientation)) 	$this->orientation= $data->orientation;
		if(isset($data->slidespacing)) 	$this->slidespacing = $data->slidespacing;
		if(isset($data->slidesnumber)) 	$this->slidesnumber = $data->slidesnumber;
		
		if(isset($data->fillmode)) 				$this->fillmode= $data->fillmode;
		if(isset($data->startindex)) 			$this->startindex= $data->startindex;
		if(isset($data->loop)) 					$this->loop= $data->loop;
		if(isset($data->width)) 				$this->width= $data->width;
		if(isset($data->height)) 				$this->height= $data->height;
		if(isset($data->autoplay)) 				$this->autoplay= $data->autoplay;
		if(isset($data->autoplaysteps)) 		$this->autoplaysteps= $data->autoplaysteps;
		if(isset($data->autoplayinterval)) 		$this->autoplayinterval= $data->autoplayinterval;
		if(isset($data->pauseonhover)) 			$this->pauseonhover= $data->pauseonhover;
		if(isset($data->cursoronhover)) 		$this->cursoronhover= $data->cursoronhover;
		if(isset($data->scale)) 				$this->scale= $data->scale;
		if(isset($data->arrowkeynavigation)) 	$this->arrowkeynavigation= $data->arrowkeynavigation;
		if(isset($data->slideduration)) 		$this->slideduration= $data->slideduration;
		
		if(isset($data->slidewidth)) 			$this->slidewidth= $data->slidewidth;
		if(isset($data->playorientation)) 		$this->playorientation= $data->playorientation;
		if(isset($data->dragorientation)) 		$this->dragorientation= $data->dragorientation;
	}
	
	public function codeWizard($partObject){}
}


