<?php
/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 */
defined('_JEXEC') or die;

defined('JPATH_PLATFORM') or die;

require_once(NGEPATH_HELPERS . '/api/panel.php');
require_once(NGEPATH_HELPERS . '/api/part/panels/slider/slidercontent.php');
require_once(NGEPATH_HELPERS . '/api/part/panels/slider/slidergeneral.php');
require_once(NGEPATH_HELPERS . '/api/part/panels/slider/sliderslides.php');
require_once(NGEPATH_HELPERS . '/api/part/panels/slider/sliderslideshow.php');
require_once(NGEPATH_HELPERS . '/api/part/panels/slider/sliderplaying.php');
require_once(NGEPATH_HELPERS . '/api/part/panels/slider/slidergrid.php');
require_once(NGEPATH_HELPERS . '/api/caption.php');
require_once(NGEPATH_HELPERS . '/api/part/panels/slider/slidercontrol.php');
require_once(NGEPATH_HELPERS . '/api/part/panels/slider/slidernavigator.php');
require_once(NGEPATH_HELPERS . '/api/part/panels/slider/sliderheader.php');
//require_once(NGEPATH_HELPERS . '/api/template.php');

/**
 * Slider class
 * @package 	Content
 * @subpackage  Panels/Thumbnails
 * @version 	1.0.0
 * @since       1.0.0
 */
 
class NgePartPanelsSlider extends NgePanel {

	/**   
	 * @var PartSliderContent $content
	 */
	public $content;

	/**
	 * @var PartSliderSlider $slider
	 */
	public $slider;
	
	/**
	 * @var PartSliderSlideshow $slideshow
	 */
	public $slideshow;
	
	/**
	 * @var PartSliderSlides $slides
	 */
	public $slides;
	
	/**
	 * @var PartSliderControl $control
	 */
	public $control;
	/**
	 * @var PartSliderNavigator $navigator
	 */
	public $navigator;

	/**
	 * @var PartSliderGrid $grid
	 */
	public $grid;
	
	/**
	 * @var PartTabstemplate $template
	 * if database mode
	 */
	public $template;
	
	function __construct(){
		parent::__construct();

		$this->apiname = 'panels.slider';
				
		//Default values
		$this->content = 		new PartSliderContent();
		$this->slider =		new PartSliderSlider();
		$this->grid = 		new PartSliderGrid();
		$this->slideshow = 		new PartSliderSlideshow();
		$this->navigator = 		new PartSliderNavigator();
		$this->playing = 		new PartSliderPlaying();		
		$this->slides =		new PartSliderSlides();
		
		
	}

	//Bind params from JRegistry data object
	protected function bind($params){
		//Common part properties
		parent::bind($params);

 		$this->content->bind($params);		
		$this->slider->bind($params->get('slider'));
		$this->grid->bind($params->get('grid'));
		$this->slideshow->bind($params->get('slideshow'));
		$this->navigator->bind($params->get('navigator'));		
		$this->playing->bind($params->get('playing'));
		$this->slides->bind($params->get('slides'));
	}

	public function codeWizard($partObject){}
}