<?php
/**
 * @package     NextGenEditor
 * @subpackage  API
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE
 */
defined('_JEXEC') or die;

defined('JPATH_PLATFORM') or die;

/**
 * Content class for slider 
 * @package     CORE
 * @version 	1.0.0
 * @since       1.0.0
 */
 
class PartSliderCustomContent{
	
	/**   
	 * @var String $source
	 */
	public $source;
	
	/**   
	 * @var String $html
	 */
	public $html;
	
	/**   
	 * @var String $article
	 */
	public $article;
	
	/**   
	 * @var String $module
	 */
	public $module;
	
	/**   
	 * @var String $url
	 */
	public $url;
	
	/**   
	 * @var String $query
	 */
	public $query;
	
	/**
	 * @var String $image
	 */
	public $image;

	/**
	 * @var String $image_caption
	 */
	public $image_caption;
	
	function __construct(){
		$this->source = 	'html';
		$this->html = 		'';
		$this->article = 	null;
		$this->module = 	null;
		$this->url = 		null;
		$this->query = 		null;
		$this->image = 		"";
		$this->image_caption = "";
	}
	
	public function bind($data){
		$this->source = 	$data->source;
		$this->html = 		$data->html;
		$this->article = 	$data->article;
		$this->module = 	$data->module;		
		$this->url = 		$data->url;
		$this->query = 		$data->query;
		$this->image = 		$data->image;
		$this->image_caption = 		$data->image_caption;
	}
	
	public function codeWizard($partObject){}
}
