<?php
/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 */
defined('_JEXEC') or die;

defined('JPATH_PLATFORM') or die;

/**
 * Slider caption class 
 * @package     CORE
 * @version 	1.0.0
 * @since       1.0.0
 */
 
class PartSliderCaption{
	/**
	 * @var String $display
	 */
	public $display;
	/**
	 * @var String $backgroundcolor
	 */
	public $backgroundcolor;
	/**
	 * @var String $opacity
	 */
	public $opacity;
	/**
	 * @var String $contentsalign
	 */
	public $contentsalign;
	/**
	 * @var String $padding
	 */
	public $padding;
	/**
	 * @var String $verticalposition
	 */
	public $verticalposition;
	/**
	 * @var String $verticalheight
	 */
	public $verticalheight;
	/**
	 * @var String $verticalmargin
	 */
	public $verticalmargin;
	/**
	 * @var String $horizontalposition
	 */
	public $horizontalposition;
	/**
	 * @var String $horizontalwidth
	 */
	public $horizontalwidth;
	/**
	 * @var String $horizontalmargin
	 */
	public $horizontalmargin;
	
	function __construct($preset = null){		
		$this->display				= "1";
		$this->backgroundcolor		= "#000000";
		$this->opacity				= "50";
		$this->contentsalign		= "top";
		$this->padding				= "5px";
		$this->verticalposition	= "bottom";
		$this->verticalheight		= "15";
		$this->verticalmargin 		= "0";
		$this->horizontalposition	= "full";
		$this->horizontalwidth		= "30";
		$this->horizontalmargin		= "0";
	}
	
	public function bind($data){
		if(isset($data->display)) 				$this->display = $data->display;
		if(isset($data->backgroundcolor)) 		$this->backgroundcolor = $data->backgroundcolor;
		if(isset($data->opacity)) 				$this->opacity = $data->opacity;
		if(isset($data->contentsalign)) 		$this->contentsalign = $data->contentsalign;
		if(isset($data->padding)) 				$this->padding = $data->padding;
		if(isset($data->verticalposition)) 	$this->verticalposition = $data->verticalposition;
		if(isset($data->verticalheight)) 		$this->verticalheight = $data->verticalheight;
		if(isset($data->verticalmargin)) 		$this->verticalmargin = $data->verticalmargin;
		if(isset($data->horizontalposition)) 	$this->horizontalposition = $data->horizontalposition;
		if(isset($data->horizontalwidth)) 		$this->horizontalwidth = $data->horizontalwidth;
		if(isset($data->horizontalmargin)) 		$this->horizontalmargin = $data->horizontalmargin;
	}
	
	public function codeWizard($partObject){}
}
