<?php
/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 */
defined('_JEXEC') or die;

defined('JPATH_PLATFORM') or die;

require_once(NGEPATH_HELPERS . '/api/bodyheight.php');
require_once(NGEPATH_HELPERS . '/api/effects/displayeffect.php');

/**
 * Panelbody class 
 * @package     CORE
 * @version 	1.0.0
 * @since       1.0.0
 */
 
class PartPanelbody{
	
	/**
	 * @var PartBodyHeight $height
	 */
	public $height;
	
	/**
	 * @var PartBorder $border
	 */
	public $padding;
	
	/**
	 * @var PartFont $font
	 */
	public $font;	
	
	/**
	 * @var array $effects
	 * Used for images and API
	 */
	public $effects;
	
	function __construct(){
		$this->height = 		new PartBodyHeight();
		$this->padding = 	new PartPadding();
 		$this->padding->default = 	'10';
		$this->font =		new PartFont();
		$this->effects		= array();
	}
	
	public function bind($data){

		if(isset($data->height_mode))	$this->height_mode = 		$data->height_mode;
		if(isset($data->height))		$this->height->bind($data->height);
		if(isset($data->hpadding)){
		    $this->padding->left = $data->hpadding;
		    $this->padding->right = $data->hpadding;
		}
		if(isset($data->vpadding)){
		    $this->padding->top = $data->vpadding;
		    $this->padding->bottom = $data->vpadding;
		}
		if(isset($data->padding)){
		    $this->padding->default = $data->padding;
		}
		if (isset ( $data->font ))		$this->font->bind ( $data->font );

		//display effects on display trigger
		if (isset($data->effects) && isset($data->effects->display) && ($data->effects->display->action !='none')){
		    $effect = new PartDisplayEffect();
		    $effect->bind($data->effects->display);
		    $effect->event='display';
		    $this->effects[] = $effect;
		}
		//display effects on hover trigger		
		if (isset($data->effects) && isset($data->effects->hover) && ($data->effects->hover->action !='none')){
		    $effect = new PartDisplayEffect();
		    $effect->bind($data->effects->hover);
		    $effect->event='hover';
		    $this->effects[] = $effect;
		}
		
	}
	
	public function codeWizard($partObject){}
}
