<?php
/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 */
defined('_JEXEC') or die;

defined('JPATH_PLATFORM') or die;

require_once(NGEPATH_HELPERS . '/api/panel.php');
require_once(NGEPATH_HELPERS . '/api/content/customcontent.php');

/**
 * Panel class
 * @package 	Content
 * @subpackage  Panels/Panel
 * @version 	1.0.0
 * @since       1.0.0
 */
 
class NgePartPanelsPanel extends NgePanel {

	/**   
	 * @var PartCustomcontent $content
	 */
	public $content;
	
	/**   
	 * @var parLink $link
	 */
	public $link;
	

	function __construct(){
		parent::__construct();

		$this->apiname = 'panels.panel';
				
		//Default values		
		$this->content = 	new PartCustomcontent();
		$this->link = 		new PartLink();				
	}

	//Bind params from JRegistry data object
	protected function bind($params){
		//Common part properties
		parent::bind($params);
		$this->content->bind($params->get('content'));
		$this->link->bind($params->get('link'));
	}

	public function codeWizard($partObject){}
}