<?php
/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 */
defined('_JEXEC') or die;


defined('JPATH_PLATFORM') or die;

require_once(NGEPATH_HELPERS . '/api/panel.php');
require_once(NGEPATH_HELPERS . '/api/content/thumbnails/thumbnailscontent.php');
require_once(NGEPATH_HELPERS . '/api/content/thumbnails/thumbnails.php');
require_once(NGEPATH_HELPERS . '/api/template.php');

/**
 * Thumbnails class
 * @package 	Content
 * @subpackage  Panels/Thumbnails
 * @version 	1.0.0
 * @since       1.0.0
 */
 
class NgePartPanelsGrid extends NgePanel {

	/**   
	 * @var PartThumbnailscontent $content
	 */
	public $content;
	/**   
	 * @var PartThumbnailsgeneral $thumbnail
	 */
	public $thumbnails;
	
	/**
	 * @var Part $template
	 * if database mode
	 */
	public $template;
	
	function __construct(){
		parent::__construct();

		$this->apiname = 'panels.grid';
				
		//Default values
		$this->body->padding->default = 0;
		
		$this->content = 	new PartThumbnailsContent();		
		$this->thumbnails = 	new PartThumbnails();
		$this->template=	new PartTemplate();
	}

	//Bind params from JRegistry data object
	protected function bind($params){
		//Common part properties
		parent::bind($params);
				
		$this->content->bind($params);		
		$this->thumbnails->bind($params->get('thumbnails'));
		$this->template->bind($params->get('template'));
	}

	public function codeWizard($partObject){}
}