<?php
/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 */
defined('_JEXEC') or die;

defined('JPATH_PLATFORM') or die;

require_once(NGEPATH_HELPERS . '/api/content/customcontent.php');
require_once(NGEPATH_HELPERS . '/api/content/contentglyph.php');

/**
 * Accordion custom content class 
 * @package     CORE
 * @version 	1.0.0
 * @since       1.0.0
 */
 
class PartAcccordionCustomContent{

	/**
	 * @var String $label
	 */
	public $label;
	
	/**   
	 * @var PartContentGlyph $glyph
	 */
	public $glyph;
	
	/**   
	 * @var PartCustomContent $body
	 */
	public $body;
		
	function __construct(){	
		$this->label =  '';
		$this->glyph = 	new PartContentGlyph();
		$this->body = 	new PartCustomContent();
	}
	
	public function bind($data){

		if (isset($data->label))	$this->label =	$data->label;
		if (isset($data->glyph))	$this->glyph->bind($data->glyph);
		//No bind for tabs (shortcuts) if (isset($data->tab))	$this->link->bind($data->tab);
		$this->body->bind($data);
	    
	}

	
	
	public function codeWizard($partObject){}
}
