<?php
/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 */
defined('_JEXEC') or die;

defined('JPATH_PLATFORM') or die;

require_once(NGEPATH_HELPERS . '/api/content/multiplecontent.php');
require_once(NGEPATH_HELPERS . '/api/part/panels/accordion/accordioncustomcontent.php');

/**
 * Accordion content class 
 * @package     CORE
 * @version 	1.0.0
 * @since       1.0.0
 */
 
class PartAccordionContent extends PartMultiplecontent{
		
	function __construct($mode='custom'){
		parent::__construct();		
		$this->mode = $mode;
	}

	protected function bindCustom($params){
	    
	    //New compatibility
	    $content = $params->get('content');
	    if (isset($content)) {
		$count = $content->count;
		for ($i=0;$i<$count; $i++){
		    $customAccordionContent = new PartAcccordionCustomContent();
		    $customAccordionContent->bind($content->items[$i]);
		    //$customLinkItem->label='ooo';
		    $this->items[] = $customAccordionContent;
		}
	    } else {	    
	    //Old compatibility V 1.0
	    $sources 	=	$params->get('sources');
	    if (isset($sources)) {
		$this->version = '1';
		$count = $params->get('count');

		//Creating default items
		for ($i=0;$i<$count; $i++){
			$this->items[] = new PartAcccordionCustomContent();
		}
			
		/***** Get Params *****/
		//Content
		$labels		= $params->get('labels');
		
		$sources 	=	$params->get('sources');
		$htmls 		= $params->get('htmls');
		$articles 	= $params->get('articles');
		$modules 	= $params->get('modules');
		$urls 		= $params->get('urls');
		$querys 	= $params->get('querys');
		
		$glyph_names 		= $params->get('glyph_names');
		
		for ($i=0;$i<$count; $i++){
			$this->items[$i]->label 		= $labels[$i];
			
			$this->items[$i]->body->source 	= $sources[$i];
			$this->items[$i]->body->html 	= $htmls[$i];
			$this->items[$i]->body->article = $articles[$i];
			$this->items[$i]->body->module 	= $modules[$i];
			$this->items[$i]->body->urls 	= $urls[$i];
			$this->items[$i]->body->query 	= $querys[$i];
			
			$this->items[$i]->glyph->name 		= $glyph_names[$i];
		}
		
	    }
	    }		
	}
	
	public function codeWizard($partObject){}
}
