<?php
/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 */
defined('_JEXEC') or die;

defined('JPATH_PLATFORM') or die;

require_once(NGEPATH_HELPERS . '/api/body.php');
require_once(NGEPATH_HELPERS . '/api/multiplebodyheight.php');

/**
 * Accordion body class 
 * @package     CORE
 * @version 	1.0.0
 * @since       1.0.0
 */
 
class PartAccordionBody extends PartBody{
	
	/**
	 * @var PartMultipleBodyHeight $height
	 */
	public $height;	
		
	
	function __construct($preset = null){

		parent::__construct();
		$this->height =				new PartMultipleBodyHeight();
	}
	
	public function bind($data){
		
		parent::bind($data);
		if(isset($data->height))		$this->height->bind($data->height);

	}
	
	public function codeWizard($partObject){}
}
