<?php
/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 */
defined('_JEXEC') or die;

defined('JPATH_PLATFORM') or die;

require_once(NGEPATH_HELPERS . '/api/panel.php');
require_once(NGEPATH_HELPERS . '/api/part/panels/accordion/accordioncontent.php');
require_once(NGEPATH_HELPERS . '/api/part/panels/accordion/accordionheadings.php');
require_once(NGEPATH_HELPERS . '/api/part/panels/accordion/accordionbody.php');

/**
 * Accordion class
 * @package 	Content
 * @subpackage  Panels/Accordion
 * @version 	1.0.0
 * @since       1.0.0
 */
 
class NgePartPanelsAccordion extends NgePanel {
	
	/**   
	 * @var PartAccordionContent $content
	 */
	public $content;
	/**
	 * @var String $trigger
	 */
	public $trigger;
	/**
	 * @var PartAccordionHeader $header
	 */
	public $headings;
	/**
	 * @var PartBody $body
	 */
	public $body;

	function __construct(){
		parent::__construct();

		$this->apiname = 'panels.accordion';
				
		//Default values		
		$this->content 	= new PartAccordionContent();
		$this->trigger 	= "click";	
		$this->headings  	= new PartAccordionHeadings();
		$this->body 	= new PartAccordionBody();
	}

	//Bind params from JRegistry data object
	protected function bind($params){
		//Common part properties
		parent::bind($params);
		
		$this->content->bind($params);
		$this->trigger 	= $params->get('trigger');		
		$this->headings->bind($params->get('headings'));
		$this->body->bind($params->get('body'));
	}

	public function codeWizard($partObject){}
}