<?php
/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 */
defined('_JEXEC') or die;

defined('JPATH_PLATFORM') or die;

require_once(NGEPATH_HELPERS . '/api/columnsrules.php');

/**
 * Display class 
 * @package     CORE
 * @version 	1.0.0
 * @since       1.0.0
 */
 


class PartListRenderingColumns{
	
	public $count;
	public $visibleitems;

	/**
	 * @var String $gap
	 */
	public $gap;

	/**   
	 * @var PartColumnsRules $rules
	 */
	public $rules;

	
	function __construct(){
		$this->count = 		'2';
		$this->visibleitems = 		'10';
		$this->gap =		'3';		
		$this->rules = 		new PartColumnsRules();		
	}
	
	public function bind($data){
		if (isset($data->count))	$this->count = 		$data->count;
		if (isset($data->visibleitems))	$this->visibleitems = 		$data->visibleitems;		
		if(isset($data->gap))		$this->gap = 		$data->gap;
		if(isset($data->rules))	$this->rules->bind($data->rules);		
	}
	
	public function codeWizard($partObject){}
}
