<?php
/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 */
defined('_JEXEC') or die;

defined('JPATH_PLATFORM') or die;

/**
 * Glyph class 
 * @package     CORE
 * @version 	1.0.0
 * @since       1.0.0
 */

class PartListPagingPager{

	/**
	 *	@var Style type of list
	 */
	public $style;

	/** 
	 *	@var String $position Glyph position from the text can be "left" or "right"
	 */
	public $position;

	/** 
	 *	@var String $align 
	 */
	public $align;
	
	/**
	 *	@var numeric $count Number of items by page
	 */
	public $length;
	
	function __construct(){
		$this->style = 		'pages';
		$this->position = 	'bottom';
		$this->align = 		'right';
		$this->length = 		10;				
	}
	
	public function bind($data){

		if (isset($data->style)) 		$this->style = 	$data->style;
		if (isset($data->position)) 		$this->position = 	$data->position;
		if (isset($data->align)) 		$this->align = 	$data->align;
		if (isset($data->length)) 		$this->length = 	$data->length;
	}
	
	public function codeWizard($partObject){}
}
