<?php
/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 */

defined('_JEXEC') or die;

defined('JPATH_PLATFORM') or die;

require_once(NGEPATH_HELPERS . '/api/part/navigation/list/listpagingpager.php');
require_once(NGEPATH_HELPERS . '/api/part/navigation/list/listpagingscroll.php');
require_once(NGEPATH_HELPERS . '/api/part/navigation/list/listpagingcolumns.php');

/**
 * Slider navigator arrow class 
 * @package     CORE
 * @version 	1.0.0
 * @since       1.0.0
 */
 
class PartListNavigationPaging{
	/**
	 * @var String $display
	 */
	public $display;
				
	/**
	 * @var String $mode
	 */
	public $mode;
	
	/**
	 * @var PartSliderNavigatorArrowsPositions $positions
	 */
//	public $position;
		
	/**   
	 * @var String $type
	 */
//	public $type;
	
	/**   
	 * @var PartListNavigationPager $pager
	 */
	public $pager;
	
	/**   
	 * @var PartListNavigationScroll $scroll
	 */
	public $scroll;
	
	/**   
	 * @var PartListNavigationColumns $columns
	 */
	public $columns;
	
	/**   
	 * @var String $length_change
	 */
//	public $length_change;
	
	
	function __construct($preset = null){		
		$this->display 		= "0"; //Default value for single lists
//		$this->position		= "top";
		$this->mode = 'pager';
		$this->pager =	new PartListPagingPager();
		$this->scroll =	new PartListPagingScroll();
		$this->columns =	new PartListPagingColumns();
//		$this->length_change = '0';
//		$this->type = 'simple_numbers';		
		
	}
	
	public function bind($data){
		if(isset($data->display))	$this->display = $data->display;
		//if (isset($data->position))	$this->positions->bind($data->positions);
		if(isset($data->mode))	$this->mode 	= $data->mode;
		//if(isset($data->type))	$this->type 	= $data->type;
		
		if (isset($data->pager))	$this->pager->bind($data->pager);
		if (isset($data->scroll))	$this->scroll->bind($data->scroll);
		if (isset($data->columns))	$this->columns->bind($data->columns);
	}
	
	public function codeWizard($partObject){}
}
