<?php
/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 */
defined('_JEXEC') or die;

defined('JPATH_PLATFORM') or die;

require_once(NGEPATH_HELPERS . '/api/body.php');
require_once(NGEPATH_HELPERS . '/api/part/navigation/list/listnavigationsearching.php');
require_once(NGEPATH_HELPERS . '/api/part/navigation/list/listnavigationpaging.php');

/**
 * Slider Navigator class 
 * @package     CORE
 * @version 	1.0.0
 * @since       1.0.0
 */
 
class PartListNavigation extends PartBody{
	
	/**
	 * @var PartListNavigationSerching $searching
	 */
	public $searching;

	/**
	 * @var PartListNAvigationPaging $paging
	 */
	public $paging;
	
	function __construct($preset = null){
		$this->searching 	= new PartListNavigationSearching();
		$this->paging	= new PartListNavigationPaging();
	}
	
	public function bind($data){
		if(isset($data->searching)) 	$this->searching->bind($data->searching);
		if(isset($data->paging)) 	$this->paging->bind($data->paging);
	}
	
	public function codeWizard($partObject){}
}