<?php
/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 */
defined('_JEXEC') or die;

defined('JPATH_PLATFORM') or die;

//require_once(NGEPATH_HELPERS . '/api/part/navigation/list/listrendering.php');
require_once(NGEPATH_HELPERS . '/api/bootstraplist.php');
require_once(NGEPATH_HELPERS . '/api/backgroundlink.php');
require_once(NGEPATH_HELPERS . '/api/border.php');
require_once(NGEPATH_HELPERS . '/api/shadow.php');

/**
 * Header class 
 * @package     CORE
 * @version 	1.0.0
 * @since       1.0.0
 */
 
class PartListList{
	
	/**
	 * @var String $style
	 */
	public $style;

	/**
	 * @var PartBootstraplist $bootstrap
	 */
	public $bootstrap;
		
	/**
	 * @var PartListRendering $rendering
	 */
	//public $rendering;
	
	/**
	 * @var PartBackground $background
	 */
	public $background;
	
	/**
	 * @var PartBorder $border
	 */
	public $border;
	
	/**
	 * @var PartShadow $shadow
	 */
	public $shadow;

	
	function __construct($preset = null){
		
		$this->style = 'default';
		$this->bootstrap =	new PartBootstraplist();
		//$this->rendering =	new PartListRendering();
		$this->background =	new PartBackgroundlink();
		$this->border = 	new PartBorder();
		$this->shadow =	new PartShadow();

	}
	
	public function bind($data){
				
		if(isset($data->style))			$this->style = $data->style;		
		if (isset($data->bootstrap))		$this->bootstrap->bind ( $data->bootstrap );
	
		//if (isset ( $data->rendering ))			$this->rendering->bind ( $data->rendering );		
		if (isset ( $data->border ))			$this->border->bind ( $data->border );
		if (isset ( $data->background ))		$this->background->bind ( $data->background );
		if (isset ( $data->shadow ))		$this->shadow->bind ( $data->shadow );		
	}
	
	public function codeWizard($partObject){}
}
