<?php
/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 */

defined('_JEXEC') or die;

defined('JPATH_PLATFORM') or die;

require_once(NGEPATH_HELPERS . '/api/panel.php');
require_once(NGEPATH_HELPERS . '/api/listitems.php');
require_once(NGEPATH_HELPERS . '/api/part/navigation/list/listlist.php');
require_once(NGEPATH_HELPERS . '/api/part/navigation/list/listnavigation.php');
require_once(NGEPATH_HELPERS . '/api/content/listcontent.php');

/**
 * Label class
 * @package 	Content
 * @subpackage  Text
 * @version 	1.0.0
 * @since       1.0.0
 */
 
class NgePartNavigationList extends NgePanel{

	/**   
	 * @var PartListcontent $content
	 */
	public $content;
		
	/**
	 * @var PartListList $list
	 */
	public $list;
	
	/**
	 * @var PartListItems $headers
	 */
	public $headers;
	
	/**
	 * @var PartListItems $items
	 */
	public $items;
	
	/**
	 * @var PartListNavigation $navigation
	 */
	public $navigation;
	
	function __construct(){
		parent::__construct();

		$this->apiname = 'navigation.list';
				
		//Default values		
		$this->body->padding->default = 0;
		
		$this->content = 	new PartListContent();
		//Default renderer for articles : list
		//$this->content->articles->renderer->style = 'list';
		
		$this->list =		new PartListList();
		$this->headers =		new PartListItems();
		$this->items =		new PartListItems();
		
		$this->navigation =		new PartListNavigation();			
	}

	//Bind params from JRegistry data object
	protected function bind($params){
		//Common part properties
		parent::bind($params);
		
		$this->content->bind($params);
		//Label default source is html
		$this->list->bind($params->get('list'));
			
		$this->headers->bind($params->get('headers'));		
		$this->items->bind($params->get('items'));
		$this->navigation->bind($params->get('navigation'));		
	}

	public function codeWizard($partObject){
	}	

}
