<?php
/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 */
defined('_JEXEC') or die;

defined('JPATH_PLATFORM') or die;

require_once(NGEPATH_HELPERS . '/api/part/navigation/list/listrenderingpager.php');
require_once(NGEPATH_HELPERS . '/api/part/navigation/list/listrenderingscroll.php');
require_once(NGEPATH_HELPERS . '/api/part/navigation/list/listrenderingcolumns.php');

/**
 * Display class 
 * @package     CORE
 * @version 	1.0.0
 * @since       1.0.0
 */
 
class PartListRendering{
	
	public $mode;
	public $pager;
	public $scroll;
	public $columns;
	
	function __construct(){
		$this->mode = 		'default';
		$this->pager =		new PartListRenderingPager();
		$this->scroll =		new PartListRenderingScroll();
		$this->columns =	new PartListRenderingColumns();
	}
	
	public function bind($data){
		if (isset($data->mode))	$this->mode = 		$data->mode;
		if (isset($data->pager))	$this->pager->bind($data->pager);
		if (isset($data->scroll))	$this->scroll->bind($data->scroll);
		if (isset($data->columns))	$this->columns->bind($data->columns);
	}
	
	public function codeWizard($partObject){}
}
