<?php
/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 */

defined('_JEXEC') or die;

defined('JPATH_PLATFORM') or die;

require_once(NGEPATH_HELPERS . '/api/item.php');
require_once(NGEPATH_HELPERS .'/api/content/label.php');
require_once(NGEPATH_HELPERS .'/api/content/sublabel.php');
require_once(NGEPATH_HELPERS . '/api/glyph.php');
require_once(NGEPATH_HELPERS . '/api/link.php');
require_once(NGEPATH_HELPERS . '/api/tooltip.php');
require_once(NGEPATH_HELPERS . '/api/popover.php');
//require_once(NGEPATH_HELPERS . '/api/effect.php');
//require_once(NGEPATH_HELPERS . '/api/transform.php');

/**
 * Label class
 * @package 	Content
 * @subpackage  Text
 * @version 	1.0.0
 * @since       1.0.0
 */
 
class NgePartNavigationLink extends NgeItem{

	/**   
	 * @var PartTitleLabel $label 
	 */
	public $label;
	
	/**   
	 * @var PartTitleSublabel $label 
	 */
	public $sublabel;
			
	/**
	* @var PartGlyph $glyph
	*/
	public $glyph;
	
	/**
	* @var PartLink $link
	*/
	public $link;
	
	/**   
	 * @var PartFont $font   
	 */
	public $font;	
	
	/**   
	 * @var PartTooltip $tooltip   
	 */
	public $tooltip;
	
	/**   
	 * @var PartPopover $popover   
	 */
	public $popover;
	
	/**   
	 * @var PartEffect $effect
	 */
	public $effect;

	/**   
	 * @var PartTransform $transform
	 */
	public $transform;

	/**   
	 * @var String $custom_color   
	 */
	public $custom_color;
	
	function __construct(){
		parent::__construct();

		$this->apiname = 'navigation.link';
				
		//Default values		
		$this->label =		new PartLabel();
		$this->sublabel =		new PartSublabel();	
		$this->link = 		new PartLink();		
		$this->tooltip = 		new PartTooltip();
		$this->popover = 		new PartPopover();
		$this->popover->header->font->size = 14; //Default value for link
		$this->glyph = 		new PartGlyph();
		$this->glyph->size = 		14;
		//$this->effect =		new PartEffect();
		//$this->transform =		new PartTransform();	

	}

	//Bind params from JRegistry data object
	protected function bind($params){		
		//Common part properties
		parent::bind($params);
		
		$this->label->bind($params->get('label'));
		$this->sublabel->bind($params->get('sublabel'));	
		
		$this->link->bind($params->get('link'));		
//		$this->tooltip->bind($params->get('tooltip'));	
		$this->popover->bind($params->get('popover'));	
		$this->glyph->bind($params->get('glyph'));	
		//$this->effect->bind($params->get('effect'));
		//$this->transform->bind($params->get('transform'));
	}

	public function codeWizard($partObject){
	}
	

}
