<?php
/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 */

defined('_JEXEC') or die;

defined('JPATH_PLATFORM') or die;

require_once(NGEPATH_HELPERS . '/api/item.php');
require_once(NGEPATH_HELPERS . '/api/dropdown.php');
require_once(NGEPATH_HELPERS . '/api/content/listcontent.php');
require_once(NGEPATH_HELPERS . '/api/button.php');
require_once(NGEPATH_HELPERS . '/api/glyph.php');
require_once(NGEPATH_HELPERS .'/api/content/label.php');
require_once(NGEPATH_HELPERS .'/api/content/sublabel.php');

/**
 * Label class
 * @package 	Content
 * @subpackage  Text
 * @version 	1.0.0
 * @since       1.0.0
 */
 
class NgePartNavigationDropdown extends NgeItem{

	/**   
	 * @var PartDropdowncontent $content
	 */
	public $content;
	
		/**   
	 * @var PartButton $button   
	 */
	public $button;
	
		/**
	* @var PartTitleLabel $label
	*/
	public $label;    			
	
	/**
	* @var PartGlyph $glyph
	*/
	public $glyph;

	
	/**
	 * @var PartListItems $items
	 */
	//public $items;
	
	/**
	 * @var PartLinks $links
	 */
	public $links;
	/**
	 * @var PartTabstabs $body
	 */
	public $dropdown;
	
	function __construct(){
		parent::__construct();

		$this->apiname = 'navigation.dropdown';
		//Default values		
		$this->content =		new PartListContent();		
		$this->label =		new PartLabel();
		$this->glyph =		new PartGlyph();
		//Default values for button glyph (used in free formula)
		$this->glyph->size='16';
		$this->glyph->color='';		

		$this->button =		new PartButton();
		$this->links =		new PartLinks();
		$this->dropdown =		new PartDropdown();

	}

	//Bind params from JRegistry data object
	protected function bind($params){		
		//Common part properties
		parent::bind($params);
		
		$button = $params->get('button');
		
		$this->content->bind($params);
		//Label default source is html
		
		$this->label->bind($params->get('label'));
		$this->glyph->bind($params->get('glyph'));		
		
		$this->button->bind($button);
		if (isset ( $data->links ))	$this->links->bind ( $data->links );
		$this->dropdown->bind($params->get('dropdown'));				
		
		//Preset style flat for button
		if (isset($button) && $button->style == 'flat') {
		    $this->label->font->style = 'custom';
		    $this->label->font->color = '#ffffff';
		    $this->button->border->style = 'solid';
		    $this->button->border->width = '0'; //For square corners
		    $this->button->background->style = 'solid';
		    if (isset($button->flat->color))  $this->button->background->color = $button->flat->color;
		    if (isset($button->flat->color_hover))  $this->button->background->color_hover = $button->flat->color_hover;
		    $this->button->style = 'custom';
		}		
	}

	public function codeWizard($partObject){
	}	

}
