<?php
/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 */

defined('_JEXEC') or die;

defined('JPATH_PLATFORM') or die;

require_once(NGEPATH_HELPERS . '/api/item.php');
require_once(NGEPATH_HELPERS . '/api/bar.php');
require_once(NGEPATH_HELPERS . '/api/content/listcontent.php');
require_once(NGEPATH_HELPERS . '/api/part/navigation/buttonbar/barbuttons.php');

/**
 * Label class
 * @package 	Content
 * @subpackage  Text
 * @version 	1.0.0
 * @since       1.0.0
 */
 
class NgePartNavigationButtonbar extends NgeItem{


	/**   
	 * @var PartBar $bar
	 */
	public $bar;
	
	/**   
	 * @var PartButton $button   
	 */
	public $buttons;
	
	/**
	 * @var PartTabstabs $body
	 */
	public $dropdown;
	
	function __construct(){
		parent::__construct();

		$this->apiname = 'navigation.buttonbar';
				
		//Default values		
		$this->content = 	new PartListContent();
		$this->bar =	new PartBar();	
		$this->buttons =	new PartBarButtons();
	}

	//Bind params from JRegistry data object
	protected function bind($params){		
		//Common part properties
		parent::bind($params);
		
		$buttons = $params->get('buttons');
		
		$this->content->bind($params);
		$this->bar->bind($params->get('bar'));		
		$this->buttons->bind($buttons);
		
		//Preset style flat for button
		if (isset($buttons) && $buttons->style == 'flat') {
		    $this->buttons->font->style = 'custom';
		    $this->buttons->font->color = '#ffffff';
		    $this->buttons->border->style = 'solid';
		    $this->buttons->border->width = '0'; //For square corners
		    $this->buttons->background->style = 'solid';		    
		    if (isset($buttons->flat->color))  $this->buttons->background->color = $buttons->flat->color;
		    if (isset($buttons->flat->color_hover))  $this->buttons->background->color_hover = $buttons->flat->color_hover;
		    $this->buttons->style = 'custom';
		}

		
		
	}

	public function codeWizard($partObject){
	}	

}
