<?php
/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 */
defined('_JEXEC') or die;

defined('JPATH_PLATFORM') or die;

require_once(NGEPATH_HELPERS . '/api/button.php');
require_once(NGEPATH_HELPERS .'/api/font.php');
require_once(NGEPATH_HELPERS . '/api/glyphs.php');
require_once(NGEPATH_HELPERS . '/api/itemwidth.php');

/**
 * Header class 
 * @package     CORE
 * @version 	1.0.0
 * @since       1.0.0
 */
 
class PartBarbuttons extends PartButton{
	
	/**
	* @var PartTitleLabel $label
	*/
	public $font;
    		
	/**
	* @var PartGlyph $glyph
	*/
	public $glyph;
	
	/**
	 * @var PartItemwidth $width
	 */
	public $width;
		
	/**
	 * @var Integer $spacewidth
	 */
	public $spacing;

	
	function __construct($preset = null){

		parent::__construct();
		$this->font =			new PartFont();
		$this->font->size = 14; //Default value
		//$this->label =			new PartButtonsLabel();				
		//$this->sublabel =			new PartButtonsSublabel();				
		$this->glyph =			new PartGlyphs();
		$this->glyph->size =			16;
		$this->glyph->color =		'';
		$this->spacing =			0;
		$this->width = 	new PartItemwidth();
		
		$this->height->value =		50; //Default value
		
	}
	
	public function bind($data){

		parent::bind($data);
		
		if (isset($data->font))		$this->font->bind($data->font);
		if (isset($data->glyph))		$this->glyph->bind($data->glyph);
		if (isset($data->spacing))	$this->spacing = $data->spacing;
		if (isset ( $data->width ))	$this->width->bind ( $data->width );
		
	}
	
	public function codeWizard($partObject){}
}
