<?php
/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 */

defined('_JEXEC') or die;

defined('JPATH_PLATFORM') or die;

require_once(NGEPATH_HELPERS . '/api/item.php');
require_once(NGEPATH_HELPERS .'/api/content/label.php');
require_once(NGEPATH_HELPERS .'/api/content/sublabel.php');
require_once(NGEPATH_HELPERS . '/api/glyph.php');
require_once(NGEPATH_HELPERS . '/api/button.php');
require_once(NGEPATH_HELPERS . '/api/link.php');
require_once(NGEPATH_HELPERS . '/api/tooltip.php');
require_once(NGEPATH_HELPERS . '/api/popover.php');
require_once(NGEPATH_HELPERS . '/api/effects/effect.php');
require_once(NGEPATH_HELPERS . '/api/transform.php');

/**
 * Label class
 * @package 	Content
 * @subpackage  Text
 * @version 	1.0.0
 * @since       1.0.0
 */
 
class NgePartNavigationButton extends NgeItem{

	/**
	* @var PartTitleLabel $label
	*/
	public $label;
    
	/**
	* @var PartTitleSublabel $sublabel
	*/
	public $sublabel;
		
	/**
	* @var PartGlyph $glyph
	*/
	public $glyph;

		/**   
	 * @var PartButton $button   
	 */
	public $button;

	/**
	* @var PartLink $link
	*/
	public $link;
	
	/**   
	 * @var PartTooltip $tooltip   
	 */
	public $tooltip;
	
	/**   
	 * @var PartPopover $popover   
	 */
	public $popover;
	
	/**   
	 * @var PartEffect $effect
	 */
	public $effects;
	
	/**   
	 * @var PartTransform $transform
	 */
	public $transform;
	
	
	function __construct(){
		parent::__construct();

		$this->apiname = 'navigation.button';
				
		//Default values		
		$this->label =		new PartLabel();
		$this->sublabel =		new PartSublabel();			
		$this->glyph =		new PartGlyph();		
		//Default values for button glyph (used in free formula)
		$this->glyph->size='16';
		$this->glyph->color='';		
		$this->button =		new PartButton();		
		$this->link = 		new PartLink();		
		//$this->font = 		new PartFont();
		$this->tooltip = 		new PartTooltip();
		$this->popover = 		new PartPopover();
		$this->effects =		array();
		$this->transform =		new PartTransform();	
	}

	//Bind params from JRegistry data object
	protected function bind($params){		
		//Common part properties
		parent::bind($params);

		$button = $params->get('button');
		$label = $params->get('label');
		$sublabel = $params->get('sublabel');					
		
		//No content in the config screen
		$this->label->bind($label);
		$this->sublabel->bind($sublabel);
		$this->glyph->bind($params->get('glyph'));
		$this->button->bind($button);
		$this->link->bind($params->get('link'));
		$this->tooltip->bind($params->get('tooltip'));
		$this->popover->bind($params->get('popover'));
		$this->transform->bind($params->get('transform'));
		
		$effects = $params->get('effects');
		if (isset($effects->hover_display_name) && ($effects->hover_display_name != ''))
		    $this->effects[] = new PartEffect('display', $effects->hover_display_name, 'hover');
		if (isset($effects->hover_background_name) && ($effects->hover_background_name != ''))
		    $this->effects[] = new PartEffect('background', $effects->hover_background_name, 'hover');
		if (isset($effects->hover_border_name) && ($effects->hover_border_name != ''))
		    $this->effects[] = new PartEffect('border', $effects->hover_border_name, 'hover');
				
		//Preset style flat
		if (isset($button) && $button->style == 'flat') {
		    $this->label->font->style = 'custom';
		    $this->label->font->color = '#ffffff';
		    $this->sublabel->font->style = 'custom';
		    $this->sublabel->font->color = '#ffffff';
		    $this->button->border->style = 'solid';
		    $this->button->border->width = '0'; //For square corners
		    $this->button->background->style = 'solid';
		    if (isset($button->flat->color))  $this->button->background->color = $button->flat->color;
		    if (isset($button->flat->color_hover))  $this->button->background->color_hover = $button->flat->color_hover;
		    $this->button->style = 'custom';
		}		
	}

	public function codeWizard($partObject){
	}
	

}
