<?php
/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 */
defined('_JEXEC') or die;

defined('JPATH_PLATFORM') or die;

/**
 * Content Glyph class 
 * @package     CORE
 * @version 	1.0.0
 * @since       1.0.0
 */
require_once(NGEPATH_HELPERS . '/api/body.php');
require_once(NGEPATH_HELPERS . '/api/sizeheightobject.php');
require_once(NGEPATH_HELPERS . '/api/part/navigation/buttonbar/barbuttons.php');
//require_once(NGEPATH_HELPERS . '/api/listitems.php');

class PartMenuBar extends PartBody{

	/**
	 * @var PartListItems $items
	 */
	public $items;
	
	/**
	 * @var String $align
	 */
	public $align;
	
	/**
	 * @var String $valign
	 */
	public $valign;

	/**
	 * @var PartSizeHeightObject $height
	 */
	public $height;
	
	
	
	function __construct(){
		
		parent::__construct();
		$this->align = 		'left';
		$this->valign = 		'top';
		$this->height =			new PartSizeHeightObject();
		$this->items =			new PartListItems();
		$this->items =			new PartBarbuttons();		
	}
	
	public function bind($data){
		parent::bind($data);
		if (isset ( $data->align ))		$this->align = $data->align;
		if (isset ( $data->valign ))		$this->valign = $data->valign;

		if (isset($data->height))		$this->height->bind($data->height);
		if (isset($data->items))		$this->items->bind($data->items);
	}
	
	public function codeWizard($partObject){}
}
