<?php
/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 */
defined('_JEXEC') or die;

defined('JPATH_PLATFORM') or die;

require_once(NGEPATH_HELPERS . '/api/button.php');
require_once(NGEPATH_HELPERS .'/api/content/label.php');
require_once(NGEPATH_HELPERS . '/api/glyph.php');

/**
 * Header class 
 * @package     CORE
 * @version 	1.0.0
 * @since       1.0.0
 */
 
class PartDropdownbutton extends PartButton{
	
	/**
	* @var PartTitleLabel $label
	*/
	public $label;    			
	
	/**
	* @var PartGlyph $glyph
	*/
	public $glyph;

	
	function __construct($preset = null){

		parent::__construct();
		$this->label =			new PartLabel();
		$this->glyph =			new PartGlyph();				

	}
	
	public function bind($data){
		
		parent::bind($data);
		
		$this->label->bind($data->label);
		$this->glyph->bind($data->glyph);		
	}
	
	public function codeWizard($partObject){}
}
