<?php
/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 */

defined('_JEXEC') or die;

defined('JPATH_PLATFORM') or die;

require_once(NGEPATH_HELPERS . '/api/panel.php');
//require_once(NGEPATH_HELPERS . '/api/content/multiplecontent.php');
require_once(NGEPATH_HELPERS . '/api/listitems.php');
require_once(NGEPATH_HELPERS . '/api/dropdown.php');
require_once(NGEPATH_HELPERS . '/api/header.php');
require_once(NGEPATH_HELPERS . '/api/shadow.php');
require_once(NGEPATH_HELPERS . '/api/border.php');
require_once(NGEPATH_HELPERS . '/api/background.php');
require_once(NGEPATH_HELPERS . '/api/part/menus/dropdown/menubar.php');
require_once(NGEPATH_HELPERS . '/api/part/menus/dropdown/menucontent.php');

/**
 * Label class
 * @package 	Content
 * @subpackage  Text
 * @version 	1.0.0
 * @since       1.0.0
 */
 


class NgePartMenusDropdown extends NgePanel{

	/**   
	 * @var PartMultipleContent $content
	 */
	public $content;

	
	/**
	 * @var PartMenuBar $bar
	 */
	public $bar;
	
		
	/**   
	 * @var PartLinks $links
	 */
	public $links;
	
	/**   
	 * @var String $position
	 */
	public $position;

	/**   
	 * @var String $orientation
	 */
	public $orientation;
	
	/**   
	 * @var String $align
	 */
	public $align;
	
	/**   
	 * @var boolean $showallchildren
	 */
	public $showallchildren;
	
		
	/**   
	 * @var PartDropdown $dropdown
	 */
	public $dropdown;
	
	/**   
	 * @var PartHeader $header
	 */
	public $header;
	
	/**   
	 * @var PartBorder $border
	 */
	public $border;
	
	/**   
	 * @var PartBackground $background
	 */
	public $background;
	
	/**
	 * @var PartShadow $shadow
	 */
	public $shadow;
	
	function __construct(){
		parent::__construct();

		$this->apiname = 'menus.dropdown';
		
		//Default values		
		$this->content = 	new PartMenuContent(); //Menu mode for this multiple content
				
		$this->bar = new PartMenuBar();

		$this->position = 'default';
		$this->orientation = 'horizontal';
		$this->align = 'left';
		$this->showallchildren = 1;
		
		$this->links = new PartLinks();
	//	$this->items = new PartListItems();
		$this->dropdown = new PartDropdown();
		$this->header = new PartHeader();
		
		$this->border = 	new PartBorder();
		$this->background = new PartBackground();
		$this->shadow = 	new PartShadow();

		
	}

	//Bind params from JRegistry data object
	protected function bind($params){		
		//Common part properties
		parent::bind($params);
		
		$this->content->bind($params);
		$this->bar->bind($params->get('bar'));
		
		$position = $params->get('position');
		$orientation = $params->get('orientation');
		$align = $params->get('align');
		$showallchildren = $params->get('showallchildren');
				
		if (isset($position))			$this->position = $position;
		if (isset($orientation))		$this->orientation = $orientation;
		if (isset($align))			$this->align = $align;
		if (isset($showallchildren))		$this->showallchildren = $showallchildren;
		
		//$this->links->bind($params->get('links'));
	//	$this->items->bind($params->get('buttons'));
		$this->dropdown->bind($params->get('dropdown'));
		
		$this->header->bind($params->get('header'));
		$this->border->bind($params->get('border'));
		$this->background->bind($params->get('background'));
		$this->shadow->bind($params->get('shadow'));

        //$this->bar = $params->get('buttons');
        	
	}

	public function codeWizard($partObject){
	}	

}
