<?php
/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 */

defined('_JEXEC') or die;
defined('JPATH_PLATFORM') or die;

require_once(NGEPATH_HELPERS . '/api/panel.php');
require_once(NGEPATH_HELPERS . '/api/content/videocontent.php');
require_once(NGEPATH_HELPERS . '/api/part/media/playerplaying.php');
require_once(NGEPATH_HELPERS . '/api/part/media/playercontrols.php');

/**
 * Tabs class
 * @package 	Content
 * @subpackage  Panels/Tabs
 * @version 	1.0.0
 * @since       1.0.0
 */

class NgePartMediaVideo extends NgePanel {

	/**   
	 * @var partVideoPlaying playng
	 */
	public $playing;
	
	/**   
	 * @var partVideoControls controls
	 */
	public $controls;

	function __construct(){
		parent::__construct();
		//Default values for image/video body
 		$this->body->padding->default = '0';
		
		$this->content =	new PartVideoContent();

		$this->apiname =	'media.video';
		$this->playing =	new PartPlayerPlaying();
		$this->controls =	new PartPlayerControls();
	}

	//Bind params from json stored parameters
	protected function bind($params){
		//Common part properties
		parent::bind($params);
		
		$content = $params->get('content');
				
		if (isset($content))	$this->content->bind($params->get('content'));	
		$this->playing->bind($params->get('playing'));		
		$this->controls->bind($params->get('controls'));	
	}

	public function codeWizard($partObject){}
}