<?php
/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 */

defined('_JEXEC') or die;

defined('JPATH_PLATFORM') or die;

require_once(NGEPATH_HELPERS . '/api/part/panels/slider/slidernavigatorarrowsarrow.php');
require_once(NGEPATH_HELPERS . '/api/part/panels/slider/slidernavigatorarrowsbackground.php');
/**
 * Slider navigator arrow class 
 * @package     CORE
 * @version 	1.0.0
 * @since       1.0.0
 */
 
class PartPlayerControls{
	
	/**
	 * @var String $trigger
	 *  hover / always / never (audio)
	 */
	public $display;
		
	/**
	 * @var String $theme
	 */
	public $theme;
	
	/**
	 * @var String $mobiles
	 */
	public $mobiles;
	
	/**
	 * @var array $features
	 */
	public $features;
		
	
	function __construct($preset = null){		
		$this->display 		= "hover";
		$this->theme		= "dark";
		$this->mobiles		= "native";
				
		$this->features		= array('play', 'progress', 'current', 'duration', 'tracks', 'volume', 'fullscreen');
		//$this->background		= new PartSliderNavigatorArrowsBackground();
	}
	
	public function bind($data){
		if(isset($data->display))		$this->display = $data->display;	
		if(isset($data->theme))		$this->theme = $data->theme;
		if(isset($data->mobiles))		$this->mobiles = $data->mobiles;	
	
		if (isset($data->features)){
		    $this->features = array();
		    if (isset($data->features->play_display) && ($data->features->play_display==1))       $this->features[] = 'play';
		    if (isset($data->features->progress_display) && ($data->features->progress_display==1))       $this->features[] = 'progress';
		    if (isset($data->features->current_display) && ($data->features->current_display==1))       $this->features[] = 'current';
		    if (isset($data->features->duration_display) && ($data->features->duration_display==1))       $this->features[] = 'duration';
//		    if (isset($data->features->tracks_display) && ($data->features->tracks_display==1))       $this->features[] = 'tracks';
		    if (isset($data->features->mute_display) && ($data->features->mute_display==1))       $this->features[] = 'mute';
		    if (isset($data->features->volume_display) && ($data->features->volume_display==1))       $this->features[] = 'volume';
		    if (isset($data->features->fullscreen_display) && ($data->features->fullscreen_display==1))       $this->features[] = 'fullscreen';
		}
	}
	
	public function codeWizard($partObject){}
}