<?php
/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 */

defined('_JEXEC') or die;
defined('JPATH_PLATFORM') or die;

require_once(NGEPATH_HELPERS . '/api/panel.php');
require_once(NGEPATH_HELPERS . '/api/part/media/playerplaying.php');
require_once(NGEPATH_HELPERS . '/api/content/flashcontent.php');

//require_once(NGEPATH_HELPERS . '/api/renderer.php');

/**
 * Tabs class
 * @package 	Content
 * @subpackage  Panels/Tabs
 * @version 	1.0.0
 * @since       1.0.0
 */

class NgePartMediaFlash extends NgePanel {

	
	/**   
	 * @var partVideoPlaying playng
	 */
	public $playing;
	
	/**   
	 * @var String file
	 */
	public $file;
	
	/**   
	 * @var String scale
	 */
	public $scale;
	
	/**   
	 * @var String wmode
	 */
	public $wmode;
	
	
		function __construct(){
		parent::__construct();

		$this->apiname =	'media.flash';		
		$this->file =	'';
		$this->content =	new PartFlashContent();
		$this->scale =	'default';
		$this->wmode =	'window';
		$this->playing =	new PartPlayerPlaying();
	}

	//Bind params from json stored parameters
	protected function bind($params){
		//Common part properties
		parent::bind($params);
		
		$this->content->bind($params->get('content'));
		$this->scale = $params->get('scale');
		$this->wmode = $params->get('wmode');
		$this->playing->bind($params->get('playing'));
	}

	public function codeWizard($partObject){}
}