<?php
/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 */

defined('_JEXEC') or die;

defined('JPATH_PLATFORM') or die;

require_once(NGEPATH_HELPERS . '/api/content/multiplecontent.php');
require_once(NGEPATH_HELPERS . '/api/part/layouts/page/pagecolumn.php');
require_once(NGEPATH_HELPERS . '/api/columnsrules.php');

/**
 * Page columns class 
 * @package     Columns
 * @version 	1.0.0
 * @since       1.0.0
 */
 
class PartPageColumns extends PartMultiplecontent{
	
	/**
	 * @var String $gap
	 */
	public $gap;
	/**
	 * @var PartColumnsRules $rules
	 */
	public $rules;
	/**
	 * @var PartColumns
	 * Column $items
	 */
	public $items;
	
	function __construct(){
		parent::__construct();
		$this->gap = '0';
		$this->rules =	new PartColumnsRules();
	}
	
	public function bind($params){
		$data = $params->get('columns');
		$count = $params->get('count');
		
		if(isset($data->gap))	$this->gap =	$data->gap;
		if(isset($data->rules))	 $this->rules = $data->rules;
		if (isset($count) && $count != 0)
		    $current_width = 100/$count;
		else 		
		    $current_width = 100;
		
		/***** Get Params *****/
		$background_styles 	= $params->get('background_styles');
		$background_colors 	= $params->get('background_colors');
		$background_color2s = $params->get('background_color2s');
		$background_images 	= $params->get('background_images');
		$contents 	= $params->get('contents');
		$widths 		= $params->get('widths');
		$paddings   = $params->get('paddings');

		//Warning, due to drag and drop capabilitis, return array can be not complete, for example $contents[0] and $contents[2]
		//In this case, returned $contents var is an object and not array
		if (gettype($contents) == 'object') {
		    $arrayContents = array();
		    for ($i =0;$i<12;$i++){ //12 columns max
			$arrayContents[$i] = isset($contents->{$i}) ? $contents->{$i} : '';
		    }	
		    $contents = $arrayContents;
		}
		if (gettype($widths) == 'object') {
		    $arrayWidths = array();
		    for ($i =0;$i<12;$i++){ //12 columns max
			$arrayWidths[$i] = isset($widths->{$i}) ? $widths->{$i} : '';
		    }	
		    $widths = $arrayWidths;
		}
		
		$total_width = 0;
		for ($i=0;$i<$count; $i++){
			//Initial value
			$this->items[$i] = new PartPageColumn();
			$this->items[$i]->width = $current_width;
			
			$padding = json_decode($paddings[$i]);
			$this->items[$i]->padding->top = (isset($padding->top)) ? $padding->top : $this->items[$i]->padding->top;
			$this->items[$i]->padding->right = (isset($padding->right)) ? $padding->right : $this->items[$i]->padding->right;
			$this->items[$i]->padding->bottom = (isset($padding->bottom)) ? $padding->bottom : $this->items[$i]->padding->bottom;
			$this->items[$i]->padding->left = (isset($padding->left)) ? $padding->left : $this->items[$i]->padding->left;
			$this->items[$i]->background->style 	= (isset($background_styles)) ? $background_styles[$i] : $this->items[$i]->background->style;
			$this->items[$i]->background->color 	= (isset($background_colors)) ? $background_colors[$i] : $this->items[$i]->background->color;
			$this->items[$i]->background->color2 	= (isset($background_color2s)) ? $background_color2s[$i] : $this->items[$i]->background->color2;
			$this->items[$i]->background->image 	= (isset($background_images)) ? $background_images[$i] : $this->items[$i]->background->image;
			//$this->items[$i]->content		= (isset($contents[$i]) && $contents[$i] != "") ? $contents[$i] : $this->items[$i]->content;
			$this->items[$i]->content		= ((isset($contents)) && (isset($contents[$i])) && $contents[$i] != "") ? $contents[$i] : $this->items[$i]->content;
			$this->items[$i]->width		= (isset($widths[$i]) && $widths[$i] != "") ? $widths[$i] : $this->items[$i]->width;
			
			$total_width += $this->items[$i]->width;
		}
		
		if($total_width > 100){
			$ratio = 100/$total_width;
			$test = 0 ;
			for ($i=0;$i<$count; $i++){
				$this->items[$i]->width = $this->items[$i]->width*$ratio;
				$test += $this->items[$i]->width;
			}
		}
	}
	
	public function codeWizard($partObject){}
}
