<?php
/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 */
defined('_JEXEC') or die;


defined('JPATH_PLATFORM') or die;

require_once(NGEPATH_HELPERS . '/api/background.php');

/**
 * Page column class 
 * @package    Columns
 * @version 	1.0.0
 * @since       1.0.0
 */
 
class PartColumnsColumn{
	/**
	 * @var String $content
	 */
	public $content;
	
	/**
	 * @var String $width
	 */
	public $width;
	
	/**
	 * @var PartBackground $background
	 */
	public $background;

	/**
	 * @var stdClass $padding
	 */
	public $padding;
	
	function __construct(){
		$this->content = "";	
		$this->width = "";	
		$this->background = new PartBackground();
		$this->padding = new stdClass();
		$this->padding->top = 0;
		$this->padding->right = 0;
		$this->padding->bottom = 0;
		$this->padding->left = 0;
	}
			
	public function bind($data){
		if(isset($data->content))	 $this->content 	= $data->content;
		if(isset($data->width))	 $this->width 	= $data->width;
		if(isset($data->background))	 $this->background->bind($data->background);
		if(isset($data->padding))	 $this->padding = $data->padding;
	}
	
	public function codeWizard($partObject){}
}
