<?php
/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 */
defined('_JEXEC') or die;

defined('JPATH_PLATFORM') or die;

require_once(NGEPATH_HELPERS . '/api/panel.php');
require_once(NGEPATH_HELPERS . '/api/part/layouts/columns/columnscolumns.php');
require_once(NGEPATH_HELPERS . '/api/header.php');
require_once(NGEPATH_HELPERS . '/api/shadow.php');
require_once(NGEPATH_HELPERS . '/api/border.php');
require_once(NGEPATH_HELPERS . '/api/background.php');

/**
 * Layout columnsclass
 * @package 	Layouts
 * @subpackage  Columns
 * @version 	1.0.0
 * @since       1.0.0
 */
 
class NgePartLayoutsColumns extends NgePanel {
	/**   
	 * @var PartHeader $header
	 */
	public $header;
	
	/**
	 * @var PartPageColumns $header
	 */
	public $columns;
	
	/**   
	 * @var PartBorder $border
	 */
	public $border;
	
	/**   
	 * @var PartBackground $background
	 */
	public $background;
	
	/**
	 * @var PartShadow $shadow
	 */
	public $shadow;
	
	/**
	 * @var String $padding
	 */
	public $padding;

	function __construct(){
		parent::__construct();

		$this->apiname = 'layouts.columns';
				
		//Default values		
		$this->header = 	new PartHeader();
		$this->columns = 	new PartColumnsColumns();
		$this->border = 	new PartBorder();
		$this->background = new PartBackground();
		$this->shadow = 	new PartShadow();
		$this->padding = 	'0';
	}

	//Bind params from JRegistry data object
	protected function bind($params){
		//Common part properties
		parent::bind($params);
		
		$this->header->bind($params->get('header'));
		$this->columns->bind($params);
		$this->border->bind($params->get('border'));
		$this->background->bind($params->get('background'));
		$this->shadow->bind($params->get('shadow'));
		
		$padding = $params->get('padding');

		if(isset($padding)) $this->padding = $padding;
	}

	public function codeWizard($partObject){}
}