<?php
/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 */
defined('_JEXEC') or die;

defined('JPATH_PLATFORM') or die;

require_once(NGEPATH_HELPERS . '/api/part.php');
require_once(NGEPATH_HELPERS . '/api/content/customcontent.php');
require_once(NGEPATH_HELPERS . '/api/part/panels/panel/panelbody.php');
require_once(NGEPATH_HELPERS . '/api/header.php');
require_once(NGEPATH_HELPERS . '/api/shadow.php');
require_once(NGEPATH_HELPERS . '/api/border.php');
require_once(NGEPATH_HELPERS . '/api/background.php');
require_once(NGEPATH_HELPERS . '/api/size.php');

/**
 * Panel class
 * @package 	Content
 * @subpackage  Panels/Panel
 * @version 	1.0.0
 * @since       1.0.0
 */
 
class NgePartLayoutsPage extends NgePart {

	/**   
	 * @var PartCustomcontent $content
	 */
	public $content;
	
	/**   
	 * @var PartPanelbody $body
	 */
	public $body;
	
	/**   
	 * @var PartHeader $header
	 */
	public $header;
	
	/**   
	 * @var PartBorder $border
	 */
	public $border;
	
	/**   
	 * @var PartBackground $background
	 */
	public $background;
	
	// TODO v 1.1
// 	/**   
// 	 * @var PartBadge $badge
// 	 */
// 	public $badge;
	/**
	 * @var PartShadow $shadow
	 */
	public $shadow;

	function __construct(){
		parent::__construct();

		$this->apiname = 'layouts.page';
				
		//Default values		
		$this->content = 	'';
		$this->body = 		new PartPanelbody();	
		$this->header = 	new PartHeader('preset1');
		$this->border = 	new PartBorder();
		$this->background = new PartBackground();
		$this->shadow = 	new PartShadow();
	}

	//Bind params from JRegistry data object
	protected function bind($params){				

		//Common part properties
		parent::bind($params);
		
		$this->content = $params->get('content');
		$this->body->bind($params->get('body'));
		$this->header->bind($params->get('header'));
		$this->border->bind($params->get('border'));
		$this->background->bind($params->get('background'));
		$this->shadow->bind($params->get('shadow'));
	}

	public function codeWizard($partObject){}
}