<?php
/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 */
defined('_JEXEC') or die;


defined('JPATH_PLATFORM') or die;

require_once(NGEPATH_HELPERS . '/api/content/multiplecontent.php');
require_once(NGEPATH_HELPERS . '/api/part/layout/columns/columncontent.php');

/**
 * Thumbnails content class 
 * @package     CORE
 * @version 	1.0.0
 * @since       1.0.0
 */
 
class PartLayoutColumnsContent extends PartMultiplecontent{
		
	    
	protected function bindCustom($params){
		
	    $content = $params->get('content');
	    if (isset($content)) {
		$count = $content->count;
		for ($i=0;$i<$count; $i++){
		    $customContent = new PartLayoutColumnContent();
		    $customContent->bind($content->items[$i]);
		    $this->items[] = $customContent;
		}
	    }
	}

	public function add($content){
	    $this->addSource('html', $content);
	    $item = new PartLayoutColumnContent();
	    $item->html 	= $content;
	    $this->items[] = $item;
	    $this->count++;
	}
	
	public function codeWizard($partObject){}
}

