<?php
/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 */
defined('_JEXEC') or die;


defined('JPATH_PLATFORM') or die;

require_once(NGEPATH_HELPERS . '/api/panel.php');
require_once(NGEPATH_HELPERS . '/api/part/layout/columns/columnscontent.php');
require_once(NGEPATH_HELPERS . '/api/part/layout/columns/columnscolumns.php');
//require_once(NGEPATH_HELPERS . '/api/content/thumbnails/thumbnails.php');

/**
 * Thumbnails class
 * @package 	Content
 * @subpackage  Panels/Thumbnails
 * @version 	1.0.0
 * @since       1.0.0
 */
 
class NgePartLayoutColumns extends NgePanel {

	/**   
	 * @var PartThumbnailscontent $content
	 */
	public $content;
	/**   
	 * @var PartThumbnailsgeneral $thumbnail
	 */
	public $columns;
	
	
	function __construct(){
		parent::__construct();

		$this->apiname = 'layout.columns';
				
		//Default values
		$this->content = 	new PartLayoutColumnsContent();		
		$this->columns = 	new PartLayoutColumnsColumns();

	}

	//Bind params from JRegistry data object
	protected function bind($params){
		//Common part properties
		parent::bind($params);
				
		$this->content->bind($params);		
		$this->columns->bind($params->get('columns'));

	}

	public function codeWizard($partObject){}
}