<?php

/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 */
defined('_JEXEC') or die;

defined('JPATH_PLATFORM') or die;

require_once(NGEPATH_HELPERS . '/api/panel.php');

/**
 * Facebook class
 * @package 	Office
 * @subpackage  Office/Facebook
 * @version 	1.0.0
 * @since       1.0.0
 */
 
class NgePartIntegrationTwitterTweet extends NgePanel {

	/**   
	 * @var string $url
	 */
	public $url;

	/**   
	 * @var string $cards
	 */
	public $cards;

	/** @var string $conversation
	 */
	public $conversation;
	 
	/** @var string $linkcolor
	 */
	public $linkcolor;
	
	/** @var string $lang
	 */
	public $lang; 

	function __construct(){
		parent::__construct();

		$this->apiname = 'integration.twitter.tweet';
				
		//Default values		
		$this->url          = '';
		$this->cards        = '';
		$this->conversation = '';
		$this->linkcolor    = '#55acee';
		$this->lang         = 'en';
	}

	//Bind params from JRegistry data object
	protected function bind($params){
		//Common part properties
		parent::bind($params);
		
		$url          = $params->get('url');
		$cards        = $params->get('cards');
		$conversation = $params->get('conversation');
		$linkcolor    = $params->get('linkcolor');
		$lang         = $params->get('lang');
		
		if (isset($url         )) $this->url          = $url         ;
		if (isset($cards       )) $this->cards        = $cards       ; 
		if (isset($conversation)) $this->conversation = $conversation;
		if (isset($linkcolor   )) $this->linkcolor    = $linkcolor   ;
		if (isset($lang        )) $this->lang         = $lang        ;
	}

	public function codeWizard($partObject){}
}
