<?php

/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 */
defined('_JEXEC') or die;

defined('JPATH_PLATFORM') or die;

require_once(NGEPATH_HELPERS . '/api/panel.php');
require_once(NGEPATH_HELPERS . '/api/body.php');

/**
 * Facebook class
 * @package 	Office
 * @subpackage  Office/Facebook
 * @version 	1.0.0
 * @since       1.0.0
 */
 
class PartTimelineBody extends PartBody{

	/**   
	 * @var $header
	 */
	public $header;
	
	/**   
	 * @var $separators
	 */
	public $separators;
	
	/**   
	 * @var $footer
	 */
	public $footer;

	/**   
	 * @var string $theme
	 */
	public $theme;
	
	/**   
	 * @var $link
	 */
	public $link;

	
	
	function __construct(){

		parent::__construct();
		$this->header = new stdClass();
		$this->header->display = true;
		
		$this->separators = new stdClass();
		$this->separators->display = true;
		$this->separators->color = '';
		
		$this->footer = new stdClass();
		$this->footer->display = true;
	    
		$this->theme = 'light'; //light / dark
		 
		$this->link = new stdClass();
		$this->link->color = '';
	}

	//Bind params from JRegistry data object
	public function bind($data){
		
		parent::bind($data);
		if (isset($data->header->display))	$this->header->display = $data->header->display;
		if (isset($data->separators->display))	$this->separators->display = $data->separators->display;
		if (isset($data->separators->color))	$this->separators->color = $data->separators->color;
		if (isset($data->footer->display))	$this->footer->display = $data->footer->display;
		if (isset($data->link->color))		$this->link->color = $data->link->color;
		if (isset($data->theme))		$this->theme = $data->theme;
	}

	public function codeWizard($partObject){}
}
