<?php

/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 */
defined('_JEXEC') or die;

defined('JPATH_PLATFORM') or die;

require_once(NGEPATH_HELPERS . '/api/panel.php');
require_once(NGEPATH_HELPERS . '/api/part/integration/twitter/timeline/timelinecontent.php');
require_once(NGEPATH_HELPERS . '/api/part/integration/twitter/timeline/timelinebody.php');

/**
 * Facebook class
 * @package 	Office
 * @subpackage  Office/Facebook
 * @version 	1.0.0
 * @since       1.0.0
 */
 
class NgePartIntegrationTwitterTimeline extends NgePanel {

	/**
	 * NgePartTimelineContent $content
	 */
	var $content;
    
	function __construct(){
		parent::__construct();
		$this->apiname = 'integration.twitter.timeline';

		//Default values		
		$this->content = new PartTimelineContent();
		$this->body = new PartTimelineBody();
		
	}

	//Bind params from JRegistry data object
	protected function bind($params){
		//Common part properties
		parent::bind($params);
		
		$this->content->bind($params->get('content'));
		$this->body->bind($params->get('body'));
	}

	public function codeWizard($partObject){}
}