<?php

/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 */
defined('_JEXEC') or die;

defined('JPATH_PLATFORM') or die;

require_once(NGEPATH_HELPERS . '/api/item.php');
require_once(NGEPATH_HELPERS . '/api/part/integration/twitter/button/buttoncontent.php');


/**
 * Facebook class
 * @package 	Office
 * @subpackage  Office/Facebook
 * @version 	1.0.0
 * @since       1.0.0
 */
 
class NgePartIntegrationTwitterButton extends NgeItem{

	 
	/** @var integer $size
	 */
	public $size;
	
	function __construct(){
		parent::__construct();

		$this->apiname      = 'integration.twitter.button';
		$this->button      = new stdClass();
		$this->button->size = 'default';
		$this->content = new PartIntegrationTwitterButtonContent();
	}

	//Bind params from JRegistry data object
	protected function bind($params){
		//Common part properties
		parent::bind($params);
		
		$content      = $params->get('content');
		$button      = $params->get('button');
		
		$this->content->bind($content);
		if (isset($button->size))       $this->button->size      = $button->size;
	}

	public function codeWizard($partObject){}
}
