<?php
/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 */
defined('_JEXEC') or die;

defined('JPATH_PLATFORM') or die;

require_once(NGEPATH_HELPERS . '/api/panel.php');

/**
 * Facebook class
 * @package 	Office
 * @subpackage  Office/Facebook
 * @version 	1.0.0
 * @since       1.0.0
 */
 
class NgePartIntegrationFacebook extends NgePanel {

    /**----------------------------------*
     *                                   *
     *         Location Parameters       *
     *                                   *
     *-----------------------------------*/
    
	/**   
	 * @var string $center
         * (required if markers not present) defines the center of the map, equidistant from all edges of the map.
         * This parameter takes a location as either a comma-separated {latitude,longitude} pair (e.g. "40.714728,-73.998672") 
         * or a string address (e.g. "city hall, new york, ny") identifying a unique location on the face of the earth.
         * https://developers.google.com/maps/documentation/staticmaps/intro#Locations
	 */
	public $center;

	/**   
	 * @var integer $zoom
         * (required if markers not present) defines the zoom level of the map, which determines the magnification level of the map. 
         * This parameter takes a numerical value corresponding to the zoom level of the region desired. For more information, see zoom levels below.
         * https://developers.google.com/maps/documentation/staticmaps/intro#Zoomlevels
	 */
	public $zoom;

    /**----------------------------------*
     *                                   *
     *            Map Parameters         *
     *                                   *
     *-----------------------------------*/

        /** 
         * @var string $size 
         * (required) defines the rectangular dimensions of the map image.
         * This parameter takes a string of the form {horizontal_value}x{vertical_value}. 
         * For example, 500x400 defines a map 500 pixels wide by 400 pixels high. 
         * Maps smaller than 180 pixels in width will display a reduced-size Google logo. 
         * This parameter is affected by the scale parameter, described below; the final output size is the product of the size and scale values.
         * https://developers.google.com/maps/documentation/staticmaps/intro#Zoomlevels
	 */
	public $size;
	 
	/** 
         * @var integer $scale 
         * (optional) affects the number of pixels that are returned
         * scale=2 returns twice as many pixels as scale=1 while retaining the same coverage area 
         * and level of detail (i.e. the contents of the map don't change). 
         * This is useful when developing for high-resolution displays, or when generating a map for printing. 
         * The default value is 1. 
         * Accepted values are 2 and 4 (4 is only available to Google Maps API for Work customers.)
	 */
	public $scale;
	
	/** 
         * @var string $format 
         * (optional) defines the format of the resulting image.
         * By default, the Static Maps API creates PNG images. 
         * There are several possible formats including GIF, JPEG and PNG types. 
         * Which format you use depends on how you intend to present the image. 
         * JPEG typically provides greater compression, while GIF and PNG provide greater detail.
         * https://developers.google.com/maps/documentation/staticmaps/intro#ImageFormats
	 */
	public $format; 

	/** 
         * @var string $maptype 
         * (optional) defines the type of map to construct. 
         * There are several possible maptype values, including roadmap, satellite, hybrid, and terrain.
         * https://developers.google.com/maps/documentation/staticmaps/intro#MapTypes
	 */
	public $maptype; 

        /**
         * @var string @language
         * (optional) defines the language to use for display of labels on map tiles.
         * Note that this parameter is only supported for some country tiles; 
         * if the specific language requested is not supported for the tile set, then the default language for that tileset will be used.
         */
	public $language; 

        /**
         * @var string $region
         * (optional) defines the appropriate borders to display, based on geo-political sensitivities.
         *  Accepts a region code specified as a two-character ccTLD ('top-level domain') value.
         */
	public $region; 

	
    /**----------------------------------*
     *                                   *
     *         Feature Parameters        *
     *                                   *
     *-----------------------------------*/

        /**
         * @var string $markers
         * (optional) define one or more markers to attach to the image at specified locations.
         * This parameter takes a single marker definition with parameters separated by the pipe character (|). 
         * Multiple markers may be placed within the same markers parameter as long as they exhibit the same style; 
         * you may add additional markers of differing styles by adding additional markers parameters. 
         * Note that if you supply markers for a map, you do not need to specify the (normally required) center and zoom parameters.
         * https://developers.google.com/maps/documentation/staticmaps/intro#Markers
         */
	public $markers; 

        /**
         * @var string $path
         * (optional) defines a single path of two or more connected points to overlay on the image at specified locations.
         * This parameter takes a string of point definitions separated by the pipe character (|). 
         * You may supply additional paths by adding additional path parameters. 
         * Note that if you supply a path for a map, you do not need to specify the (normally required) center and zoom parameters.
         * https://developers.google.com/maps/documentation/staticmaps/intro#Paths
         */
	public $path; 

        /**
         * @var string $visible
         * (optional) specifies one or more locations that should remain visible on the map, though no markers or other indicators will be displayed. 
         * Use this parameter to ensure that certain features or map locations are shown on the Static Map.
         */
	public $visible; 

        /**
         * @var string $style
         * (optional) defines a custom style to alter the presentation of a specific feature (road, park, etc.) of the map. 
         * This parameter takes feature and element arguments identifying the features to select and a set of style operations to apply to that selection. 
         * You may supply multiple styles by adding additional style parameters.
         * https://developers.google.com/maps/documentation/staticmaps/intro#StyledMaps
         */
	public $style; 

	function __construct(){
		parent::__construct();

		$this->apiname = 'integration.gmap';
				
		//Default values		
		$this->center   = "";
		$this->zoom     = "";
		$this->size     = "";
		$this->scale    = "";
		$this->format   = "";
		$this->maptype  = "";
		$this->language = "";
		$this->region   = "";
		$this->markers  = "";
		$this->path     = "";
		$this->visible  = "";
		$this->style    = "";
	}

	//Bind params from JRegistry data object
	protected function bind($params){
		//Common part properties
		parent::bind($params);
		
		$url = $params->get('url');
		$cover = $params->get('cover');
		$facepile = $params->get('facepile');
		$cta = $params->get('cta');
		$posts = $params->get('posts');
		$height = $params->get('height');
		
		if (isset($url))		$this->url = $url;
		if (isset($cover))	$this->cover = $cover;
		if (isset($facepile))	$this->facepile = $facepile;
		if (isset($cta))		$this->cta = $cta;
		if (isset($posts))	$this->posts = $posts;
		if (isset($height))	$this->height = $height;
	}

	public function codeWizard($partObject){}
}