<?php
/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 */
defined('_JEXEC') or die;

defined('JPATH_PLATFORM') or die;

require_once(NGEPATH_HELPERS . '/api/panel.php');

/**
 * Facebook class
 * @package 	Office
 * @subpackage  Office/Facebook
 * @version 	1.0.0
 * @since       1.0.0
 */
 
class NgePartIntegrationFacebook extends NgePanel {

	/**   
	 * @var string $url
	 */
	public $url;

	/**   
	 * @var boolean $cover
	 */
	public $cover;

	/** @var boolean $facepile
	 */
	public $facepile;
	 
	/** @var boolean $cta
	 */
	public $cta;
	
	/** @var boolean $posts
	 */
	public $posts; 

	/** @var integer $height
	 */
	public $height; 

	
	function __construct(){
		parent::__construct();

		$this->apiname = 'integration.facebook';
				
		//Default values		
		$this->url = 	'';
		$this->cover =		true;
		$this->facepile = 	true;
		$this->cta =		true;
		$this->posts =		false;
		$this->height =		500;
	}

	//Bind params from JRegistry data object
	protected function bind($params){
		//Common part properties
		parent::bind($params);
		
		$url = $params->get('url');
		$cover = $params->get('cover');
		$facepile = $params->get('facepile');
		$cta = $params->get('cta');
		$posts = $params->get('posts');
		$height = $params->get('height');
		
		if (isset($url))		$this->url = $url;
		if (isset($cover))	$this->cover = $cover;
		if (isset($facepile))	$this->facepile = $facepile;
		if (isset($cta))		$this->cta = $cta;
		if (isset($posts))	$this->posts = $posts;
		if (isset($height))	$this->height = $height;
	}

	public function codeWizard($partObject){}
}