<?php
/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 */

defined('_JEXEC') or die;
defined('JPATH_PLATFORM') or die;


//require_once(NGEPATH_HELPERS . '/api/renderer.php');
require_once(NGEPATH_HELPERS . '/api/part/images/image/imagezoomborder.php');

/**
 * Tabs class
 * @package 	Content
 * @subpackage  Panels/Tabs
 * @version 	1.0.0
 * @since       1.0.0
 */

class PartImageZoomWindow extends NgePart{
	
    	/**   
	 * @var string $shape
	 */
	public $shape;
    	
	/**   
	 * @var string $width
	 */
	public $width;
	
	/**   
	 * @var string $height
	 */
	public $height;

	/**   
	 * @var string $position
	 */
	public $position;
	
	/**   
	 * @var string $margin
	 */
	public $margin;
	
	/**   
	 * @var PartImageZoomBorder $border
	 */
	public $border;
	
	
	function __construct(){
		parent::__construct();
		$this->shape = 'square';
		$this->width =		'400';
		$this->height = 		'400';
		$this->position = 		'rightinnertop';
		$this->margin =		'0';
		$this->border = 		new PartImageZoomBorder();		
	}

	//Bind params from json stored parameters
	public function bind($data){
		if (isset($data->shape))	$this->shape = $data->shape;
		if (isset($data->width))	$this->width = $data->width;
		if (isset($data->height))	$this->height = $data->height;
		if (isset($data->mainposition)){
		    if ($data->mainposition == 'top' || $data->mainposition == 'bottom')
			$this->position = $data->mainposition.$data->hposition;		
		    else
			$this->position = $data->mainposition.$data->vposition;		
		}
		if (isset($data->margin))	$this->margin = $data->margin;
		if (isset($data->border))	$this->border->bind($data->border);				
	}

	public function codeWizard($partObject){}
}