<?php
/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 */

defined('_JEXEC') or die;
defined('JPATH_PLATFORM') or die;

require_once(NGEPATH_HELPERS . '/api/part/images/image/imagezoomborder.php');
//require_once(NGEPATH_HELPERS . '/api/renderer.php');

/**
 * Tabs class
 * @package 	Content
 * @subpackage  Panels/Tabs
 * @version 	1.0.0
 * @since       1.0.0
 */

class PartImageZoomLens extends NgePart{
	
	/**   
	 * @var string $shape
	 */
	public $shape;
	
	/**   
	 * @var PartImageZoomBorder $border
	 */
	public $border;

	/**   
	 * @var parEffect $effect
	 */
	public $size;
	

	function __construct(){
		parent::__construct();

		$this->shape =		'circle';
		$this->size = 		200;
		$this->border = 		new PartImageZoomBorder();		
	}

	//Bind params from json stored parameters
	public function bind($data){
		if (isset($data->shape))	$this->shape = $data->shape;
		if (isset($data->size))	$this->size = $data->size;
		if (isset($data->border))	$this->border->bind($data->border);				
	}

	public function codeWizard($partObject){}
}