<?php
/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 */

defined('_JEXEC') or die;
defined('JPATH_PLATFORM') or die;


//require_once(NGEPATH_HELPERS . '/api/renderer.php');
require_once(NGEPATH_HELPERS . '/api/part/images/image/imagezoombackground.php');
require_once(NGEPATH_HELPERS . '/api/part/images/image/imagezoomlens.php');
require_once(NGEPATH_HELPERS . '/api/part/images/image/imagezoomwindow.php');


/**
 * Tabs class
 * @package 	Content
 * @subpackage  Panels/Tabs
 * @version 	1.0.0
 * @since       1.0.0
 */

class PartImageZoom extends NgePart{
	
	/**   
	 * @var string $style
	 */
	public $style;
	
	/**   
	 * @var string $cursor
	 */
	public $cursor;

	/**   
	 * @var PartImageZoomBackground $background
	 */
	public $background;

	/**   
	 * @var PartImageZoomLens $lens
	 */
	public $lens;

	/**   
	 * @var PartImageZoomWindow $window
	 */
	public $window;
	
	/**   
	 * @var parTransform $transform
	 */
//	public $transform;
	
	/**   
	 * @var parHovereffect $hovereffect
	 */
//	public $hovereffect;

	function __construct(){
		parent::__construct();

		$this->style =		'none'; //window, inner, lens
		$this->cursor =		'crosshair'; 
		$this->background = 		new PartImageZoomBackground();		
		$this->lens = 		new PartImageZoomLens();		
		$this->window =		new PartImageZoomWindow();		
//		$this->transform = 		new PartTransform();		
//		$this->hovereffect = 	new PartHovereffect();	
				
	}

	//Bind params from json stored parameters
	public function bind($data){
		//Common part properties

		if (isset($data->style))	$this->style = $data->style;
		if (isset($data->cursor))	$this->cursor = $data->cursor;
		if (isset($data->background))	$this->background->bind($data->background);
		if (isset($data->lens))	$this->lens->bind($data->lens);
		if (isset($data->window))	$this->window->bind($data->window);
	}

	public function codeWizard($partObject){}
}