<?php
/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 */

defined('_JEXEC') or die;
defined('JPATH_PLATFORM') or die;

require_once(NGEPATH_HELPERS . '/api/content/imagecontent.php');
require_once(NGEPATH_HELPERS . '/api/panel.php');
require_once(NGEPATH_HELPERS . '/api/caption.php');
require_once(NGEPATH_HELPERS . '/api/link.php');
require_once(NGEPATH_HELPERS . '/api/animationeffect.php');
//require_once(NGEPATH_HELPERS . '/api/hovereffect.php');
require_once(NGEPATH_HELPERS . '/api/legend.php');
require_once(NGEPATH_HELPERS . '/api/background.php');
require_once(NGEPATH_HELPERS . '/api/tooltip.php');
require_once(NGEPATH_HELPERS . '/api/popover.php');
require_once(NGEPATH_HELPERS . '/api/part/images/image/imagezoom.php');
require_once(NGEPATH_HELPERS . '/api/part/images/image/imageshape.php');

//require_once(NGEPATH_HELPERS . '/api/renderer.php');

/**
 * Tabs class
 * @package 	Content
 * @subpackage  Panels/Tabs
 * @version 	1.0.0
 * @since       1.0.0
 */

class NgePartImagesImage extends NgePanel {

	/**   
	 * @var string $content
	 */
	public $content;
	
	/**   
	 * @var string $image
	 */
	public $image;

	/**   
	 * @var string $image_hover
	 */
	public $image_hover;
	
	/**   
	 * @var string $style
	 */
	public $style;

	/**   
	 * @var parCaption $caption   
	 * Caption content and options
	 */
	public $caption;
	
	/**   
	 * @var parLegend $legend   
	 * Legend content and options
	 */
	public $legend;
	
	/**   
	 * @var parLink $link
	 */
	public $link;

	/**   
	 * @var parEffect $effect
	 */
	public $effect;
	
		/**   
	 * @var PartTooltip $tooltip   
	 */
	public $tooltip;
	
	/**   
	 * @var PartPopover $popover   
	 */
	public $popover;

	/**   
	 * @var PartImagezoom $zoom
	 */
	public $zoom;
	
	/**   
	 * @var parImageShape $shape
	 */
	public $shape;
	
	/**   
	 * @var parHovereffect $hovereffect
	 */
//	public $hovereffect;
	
	

	function __construct(){
		parent::__construct();

		$this->apiname =		'images.image';
		$this->image =		''; //Shortcut for content.body
		$this->image_hover =	''; //Shortcut for content.hover
		$this->content =		new PartImageContent();		
		$this->style =		'default';
		$this->caption = 		new PartCaption();
		$this->legend = 		new PartLegend();
		$this->link = 		new PartLink();		
		//$this->effect =		new PartEffect();		
		$this->zoom = 		new PartImageZoom();
		$this->shape = 		new PartImageShape();
//		$this->transform = 		new PartTransform();		
//		$this->hovereffect = 	new PartHovereffect();
		
		$this->style_hover =		'hover';
		$this->tooltip = 		new PartTooltip();
		$this->popover = 		new PartPopover();
		
		//Default value for images
		$this->body->padding->default	= 0;		
					
	}

	//Bind params from json stored parameters
	protected function bind($params){
		//Common part properties
		parent::bind($params);
						
		$this->style = $params->get('style');
		
		$this->content->bind($params->get('content'));
		
		//Shortcuts
		$image = $params->get('image');
		if ($image != ''){
		    $this->content->body->source = 'image';
		    $this->content->body->image = $image;
		}
		$image_hover = $params->get('image_hover');
		if ($image_hover != ''){
		    $this->content->hover->source = 'image';
		    $this->content->hover->image = $image_hover;
		}
		
		
		$this->caption->bind($params->get('caption'));
		$this->link->bind($params->get('link'));
		//$this->effect->bind($params->get('effect'));	
		$this->zoom->bind($params->get('zoom'));
		$this->shape->bind($params->get('shape'));
//		$this->transform->bind($params->get('transform'));	
//		$this->hovereffect->bind($params->get('hovereffect'));	
		
		$this->style_hover = $params->get('style_hover');	
		$this->tooltip->bind($params->get('tooltip'));	
		$this->popover->bind($params->get('popover'));	

	}

	public function codeWizard($partObject){}
}