<?php
/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 */

defined('_JEXEC') or die;

defined('JPATH_PLATFORM') or die;

require_once(NGEPATH_HELPERS . '/api/part.php');
require_once(NGEPATH_HELPERS . '/api/link.php');
require_once(NGEPATH_HELPERS . '/api/tooltip.php');
require_once(NGEPATH_HELPERS . '/api/popover.php');

/**
 * Label class
 * @package 	Content
 * @subpackage  Text
 * @version 	1.0.0
 * @since       1.0.0
 */
 
class NgePartImagesThumbnail extends NgePart{

	/**   
	 * @var String $image   
	 * Image path
	 */
	public $image;
		
	/**   
	 * @var String $style   
	 */
	public $style;
		
	/**   
	 * @var PartTooltip $tooltip   
	 */
	public $tooltip;
	
	/**   
	 * @var PartPopover $popover   
	 */
	public $popover;
	
	/**   
	 * @var PartLink $link   
	 */
	public $link
			;
	function __construct(){
		parent::__construct();

		$this->apiname = 'images.thumbnail';
				
		//Default values		
		$this->image = 		'';
		$this->style = 			'default';
		$this->tooltip = 		new PartTooltip();
		$this->popover = 		new PartPopover();
		$this->link =			new PartLink();
		$this->size->display =	'inline';
	}

	//Bind params from JRegistry data object
	protected function bind($params){		
		//Common part properties
		parent::bind($params);
		
		//No content in the config screen
		$this->image = 			$params->get('image');
		$this->style = 			$params->get('style');
		$this->tooltip->bind($params->get('tooltip'));	
		$this->popover->bind($params->get('popover'));	
		$this->link->bind($params->get('link'));	
	}
	
}
