<?php
/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 */
defined('_JEXEC') or die;

defined('JPATH_PLATFORM') or die;

require_once(NGEPATH_HELPERS . '/api/border.php');
require_once(NGEPATH_HELPERS . '/api/background.php');

/**
 * Table Rows class 
 * @package     Data
 * @version 	1.0.0
 * @since       1.0.0
 */
class PartReportTableRows {

    /**
     * @var String $compact
     */
    public $lineheight;


    /**
     * @var PartBackground $background
     */
    public $background;

    function __construct() {
	$this->lineheight = '1em';
	$this->background = new PartBackground();
    }

    public function bind($data) {

	if (isset($data->height->mode))
	    switch ($data->height->mode){
		case 'relative' :
		    if (isset($data->height->relative))
			$this->lineheight = $data->height->relative . 'em';
		    break;
		case 'absolute' :
		    if (isset($data->height->absolute))
			$this->lineheight = $data->height->absolute . 'px';
		    break;
	    }
	//$this->background->bind($data->background);
    }

    public function codeWizard($partObject) {
	
    }

}
