<?php
/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 */

defined('_JEXEC') or die;

defined('JPATH_PLATFORM') or die;

require_once(NGEPATH_HELPERS . '/api/part/database/reporting/table/tablepaging.php');

/**
 * Table Navigation class 
 * @package     Data
 * @version 	1.0.0
 * @since       1.0.0
 */
 
class PartReportTableNavigation{
	
	/**
	 * @var PartTablePaging $paging
	 */
	public $paging;
	
	/**   
	 * @var String $searching
	 */
	public $searching;
	
	/**   
	 * @var String $ordering
	 */
	public $ordering;
	
	/**   
	 * @var String $resizing
	 */
	public $resizing;
	
	/**
	 * @var String $info
	 */
	public $info;
		
	function __construct(){		
		$this->paging 		= new PartTablePaging();
		$this->searching 	= '0';
		$this->ordering 	= '0';
		$this->resizing 	= '0';
		$this->info 	= '0';
	}
	
	public function bind($data){
		if(isset($data->paging))	$this->paging 		= $data->paging;
		if(isset($data->searching))	$this->searching 	= $data->searching;
		if(isset($data->ordering))	$this->ordering 	= $data->ordering;
		if(isset($data->resizing))	$this->resizing 	= $data->resizing;
		if(isset($data->info))		$this->info 	= $data->info;
	}
	
	public function codeWizard($partObject){}
}
