<?php
/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 */

defined('_JEXEC') or die;

defined('JPATH_PLATFORM') or die;

require_once(NGEPATH_HELPERS . '/api/font.php');

/**
 * Table Cols class 
 * @package     Data
 * @version 	1.0.0
 * @since       1.0.0
 */
 
class PartReportTableGroupHeader extends PartBody{
		
	
    	/**
	* @var String $display
	*/
	public $display;

	/**
	* @var String $align
	*/
	public $align;
    
    	/**
	 * @var PartFont $font
	 */
	public $font;

	/**
	 * @var String $padding
	 */
	public $padding;
	
	function __construct(){

		parent::__construct();
		$this->align	= 'left';
		$this->font = 	new PartFont();
	}
	
		
	public function bind($data){
	    
	    //Body
	    parent::bind($data);	
	
	    if (isset($data->display))		 	$this->display = 		$data->display;
	    if (isset($data->align))		 	$this->align = 		$data->align;
	    if (isset($data->font))
		$this->font->bind($data->font);
	}

	
	public function codeWizard($partObject){}
}